/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.core.v3;

import com.huawei.gaussdb.jdbc.core.PGStream;
import com.huawei.gaussdb.jdbc.core.ParameterList;
import com.huawei.gaussdb.jdbc.core.Utils;
import com.huawei.gaussdb.jdbc.core.v3.TypeTransferModeRegistry;
import com.huawei.gaussdb.jdbc.core.v3.V3ParameterList;
import com.huawei.gaussdb.jdbc.geometric.PGbox;
import com.huawei.gaussdb.jdbc.geometric.PGpoint;
import com.huawei.gaussdb.jdbc.jdbc.UUIDArrayAssistant;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.ClientLogic;
import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import com.huawei.gaussdb.jdbc.util.ByteConverter;
import com.huawei.gaussdb.jdbc.util.GT;
import com.huawei.gaussdb.jdbc.util.PSQLException;
import com.huawei.gaussdb.jdbc.util.PSQLState;
import com.huawei.gaussdb.jdbc.util.StreamWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Arrays;

class SimpleParameterList
implements V3ParameterList {
    private static Log LOGGER = Logger.getLogger(SimpleParameterList.class.getName());
    private static final byte IN = 1;
    private static final byte OUT = 2;
    private static final byte INOUT = 3;
    private static final byte TEXT = 0;
    private static final byte BINARY = 4;
    private final String[] paramLiteralValues;
    private final Object[] paramValues;
    private final int[] paramTypes;
    private final byte[] flags;
    private final byte[][] encoded;
    private final TypeTransferModeRegistry transferModeRegistry;
    private final boolean[] isACompatibilityFunctions;
    private final String[] compatibilityModes;
    private static final Object NULL_OBJECT = new Object();
    private int pos = 0;

    SimpleParameterList(int paramCount, TypeTransferModeRegistry transferModeRegistry) {
        this.paramLiteralValues = new String[paramCount];
        this.paramValues = new Object[paramCount];
        this.paramTypes = new int[paramCount];
        this.encoded = new byte[paramCount][];
        this.flags = new byte[paramCount];
        this.transferModeRegistry = transferModeRegistry;
        this.compatibilityModes = new String[paramCount];
        this.isACompatibilityFunctions = new boolean[paramCount];
    }

    @Override
    public void registerOutParameter(int index, int sqlType) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("COLUMN_INDEX_OUT_OF_RANGE", index, this.paramValues.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        int n = index - 1;
        this.flags[n] = (byte)(this.flags[n] | 2);
    }

    @Override
    public void bindRegisterOutParameter(int index, int oid, boolean isACompatibilityFunction) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("COLUMN_INDEX_OUT_OF_RANGE", index, this.paramValues.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.paramTypes[index - 1] = oid;
        this.compatibilityModes[index - 1] = "ORA";
        this.isACompatibilityFunctions[index - 1] = isACompatibilityFunction;
    }

    private void bind(int index, Object value, int oid, byte binary) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("COLUMN_INDEX_OUT_OF_RANGE", index, this.paramValues.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.encoded[--index] = null;
        this.paramValues[index] = value;
        this.flags[index] = (byte)(this.direction(index) | 1 | binary);
        if (oid == 0 && this.paramTypes[index] != 0 && value == NULL_OBJECT) {
            return;
        }
        this.paramTypes[index] = oid;
        this.pos = index + 1;
    }

    @Override
    public int getParameterCount() {
        return this.paramValues.length;
    }

    @Override
    public int getOutParameterCount() {
        int count = 0;
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if ((this.direction(i) & 2) != 2) continue;
            ++count;
        }
        if (count == 0) {
            count = 1;
        }
        return count;
    }

    @Override
    public int getInParameterCount() {
        int count = 0;
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction(i) == 2) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void setIntParameter(int index, int value) throws SQLException {
        byte[] data = new byte[4];
        ByteConverter.int4(data, 0, value);
        this.bind(index, data, 23, (byte)4);
    }

    @Override
    public void setLiteralParameter(int index, String value, int oid) throws SQLException {
        this.bind(index, value, oid, (byte)0);
        this.saveLiteralValueForClientLogic(index, value);
    }

    @Override
    public void setStringParameter(int index, String value, int oid) throws SQLException {
        this.bind(index, value, oid, (byte)0);
        this.saveLiteralValueForClientLogic(index, value);
    }

    @Override
    public void setBinaryParameter(int index, byte[] value, int oid) throws SQLException {
        this.bind(index, value, oid, (byte)4);
    }

    @Override
    public void saveLiteralValueForClientLogic(int index, String value) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("COLUMN_INDEX_OUT_OF_RANGE", index, this.paramValues.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.paramLiteralValues[--index] = value;
    }

    @Override
    public String[] getLiteralValues() {
        return this.paramLiteralValues;
    }

    @Override
    public void setClientLogicBytea(int index, byte[] data, int offset, int length, int customOid) throws SQLException {
        this.bind(index, new StreamWrapper(data, offset, length), customOid, (byte)4);
    }

    @Override
    public void setBytea(int index, byte[] data, int offset, int length) throws SQLException {
        this.bind(index, new StreamWrapper(data, offset, length), 17, (byte)4);
    }

    @Override
    public void setBytesForM(int index, byte[] data, int offset, int length) throws SQLException {
        this.bind(index, new StreamWrapper(data, offset, length), 0, (byte)4);
    }

    @Override
    public void setBytea(int index, InputStream stream, int length) throws SQLException {
        this.bind(index, new StreamWrapper(stream, length), 17, (byte)4);
    }

    @Override
    public void setBytea(int index, InputStream stream) throws SQLException {
        this.bind(index, new StreamWrapper(stream), 17, (byte)4);
    }

    @Override
    public void setBlob(int index, byte[] data, int offset, int length) throws SQLException {
        this.bind(index, new StreamWrapper(data, offset, length), 88, (byte)4);
    }

    @Override
    public void setBlob(int index, InputStream stream, int length) throws SQLException {
        this.bind(index, new StreamWrapper(stream, length), 88, (byte)4);
    }

    @Override
    public void setBlob(int index, InputStream stream) throws SQLException {
        this.bind(index, new StreamWrapper(stream), 88, (byte)4);
    }

    @Override
    public void setBlobForM(int index, byte[] data, int offset, int length) throws SQLException {
        this.bind(index, new StreamWrapper(data, offset, length), 0, (byte)4);
    }

    @Override
    public void setBlobForM(int index, InputStream is) throws SQLException {
        this.bind(index, new StreamWrapper(is), 0, (byte)4);
    }

    @Override
    public void setBlobForM(int index, InputStream is, int length) throws SQLException {
        this.bind(index, new StreamWrapper(is, length), 0, (byte)4);
    }

    @Override
    public void setText(int index, InputStream stream) throws SQLException {
        this.bind(index, new StreamWrapper(stream), 25, (byte)0);
    }

    @Override
    public void setNull(int index, int oid) throws SQLException {
        byte binaryTransfer = 0;
        if (oid == 88 || oid == 17) {
            binaryTransfer = 4;
        }
        if (this.transferModeRegistry.useBinaryForReceive(oid)) {
            binaryTransfer = 4;
        }
        if (ClientLogic.isClientLogicField(oid)) {
            binaryTransfer = 4;
        }
        this.saveLiteralValueForClientLogic(index, "");
        this.bind(index, NULL_OBJECT, oid, binaryTransfer);
    }

    @Override
    public String toString(int index, boolean standardConformingStrings) {
        Object paramValue;
        if ((paramValue = this.paramValues[--index]) == null) {
            return "?";
        }
        if (paramValue == NULL_OBJECT) {
            return "(NULL)";
        }
        if ((this.flags[index] & 4) == 4) {
            String textValue = null;
            switch (this.paramTypes[index]) {
                case 21: {
                    short s = ByteConverter.int2((byte[])paramValue, 0);
                    textValue = Short.toString(s);
                    break;
                }
                case 23: {
                    int i = ByteConverter.int4((byte[])paramValue, 0);
                    textValue = Integer.toString(i);
                    break;
                }
                case 20: {
                    long l = ByteConverter.int8((byte[])paramValue, 0);
                    textValue = Long.toString(l);
                    break;
                }
                case 700: {
                    float f = ByteConverter.float4((byte[])paramValue, 0);
                    textValue = Float.toString(f);
                    break;
                }
                case 701: {
                    double d = ByteConverter.float8((byte[])paramValue, 0);
                    textValue = Double.toString(d);
                    break;
                }
                case 2950: {
                    String uuid = new UUIDArrayAssistant().buildElement((byte[])paramValue, 0, 16).toString();
                    textValue = "'" + uuid + "'::uuid";
                    break;
                }
                case 600: {
                    PGpoint pgPoint = new PGpoint();
                    pgPoint.setByteValue((byte[])paramValue, 0);
                    textValue = "'" + pgPoint.toString() + "'::point";
                    break;
                }
                case 603: {
                    PGbox pgBox = new PGbox();
                    pgBox.setByteValue((byte[])paramValue, 0);
                    textValue = "'" + pgBox.toString() + "'::box";
                }
            }
            return textValue == null ? "?" : "(" + textValue + ")";
        }
        String param = paramValue.toString();
        StringBuilder p = new StringBuilder(3 + (param.length() + 10) / 10 * 11);
        p.append("('");
        try {
            p = Utils.escapeLiteral(p, param, standardConformingStrings);
        }
        catch (SQLException sqle) {
            p.append(param);
        }
        p.append('\'');
        int paramType = this.paramTypes[index];
        if (paramType == 1114) {
            p.append("::timestamp");
        } else if (paramType == 1184) {
            p.append("::timestamp with time zone");
        } else if (paramType == 1083) {
            p.append("::time");
        } else if (paramType == 1266) {
            p.append("::time with time zone");
        } else if (paramType == 1082) {
            p.append("::date");
        } else if (paramType == 1186) {
            p.append("::interval");
        }
        return p.append(')').toString();
    }

    @Override
    public void checkAllParametersSet() throws SQLException {
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction(i) == 2 || this.paramValues[i] != null) continue;
            throw new PSQLException(GT.tr("PARAMETERS_NOT_SET", i + 1), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public void convertFunctionOutParameters() {
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction(i) != 2) continue;
            if (this.compatibilityModes[i] != null && this.compatibilityModes[i].equalsIgnoreCase("ORA")) {
                if (this.isACompatibilityFunctions[i] && i == 0) {
                    this.paramTypes[i] = 2278;
                }
                this.paramValues[i] = "null";
                continue;
            }
            this.paramTypes[i] = 2278;
            this.paramValues[i] = "null";
        }
    }

    private static void streamBytea(PGStream pgStream, StreamWrapper wrapper) throws IOException {
        byte[] rawData = wrapper.getBytes();
        if (rawData != null) {
            pgStream.send(rawData, wrapper.getOffset(), wrapper.getLength());
            return;
        }
        pgStream.sendStream(wrapper.getStream(), wrapper.getLength());
    }

    @Override
    public int[] getTypeOIDs() {
        return this.paramTypes;
    }

    int getTypeOID(int index) {
        return this.paramTypes[index - 1];
    }

    boolean hasUnresolvedTypes() {
        for (int paramType : this.paramTypes) {
            if (paramType != 0) continue;
            return true;
        }
        return false;
    }

    void setResolvedType(int index, int oid) {
        if (this.paramTypes[index - 1] == 0) {
            this.paramTypes[index - 1] = oid;
        } else if (this.paramTypes[index - 1] != oid) {
            throw new IllegalArgumentException("Can't change resolved type for param: " + index + " from " + this.paramTypes[index - 1] + " to " + oid);
        }
    }

    boolean isNull(int index) {
        return this.paramValues[index - 1] == NULL_OBJECT;
    }

    boolean isBinary(int index) {
        return (this.flags[index - 1] & 4) != 0;
    }

    private byte direction(int index) {
        return (byte)(this.flags[index] & 3);
    }

    int getV3Length(int index) {
        if (this.paramValues[--index] == NULL_OBJECT) {
            throw new IllegalArgumentException("can't getV3Length() on a null parameter");
        }
        if (this.paramValues[index] instanceof byte[]) {
            return ((byte[])this.paramValues[index]).length;
        }
        if (this.paramValues[index] instanceof StreamWrapper) {
            return ((StreamWrapper)this.paramValues[index]).getLength();
        }
        if (this.encoded[index] == null) {
            this.encoded[index] = Utils.encodeUTF8(this.paramValues[index].toString());
        }
        return this.encoded[index].length;
    }

    void writeV3Value(int index, PGStream pgStream) throws IOException {
        if (this.paramValues[--index] == NULL_OBJECT) {
            throw new IllegalArgumentException("can't writeV3Value() on a null parameter");
        }
        if (this.paramValues[index] instanceof byte[]) {
            pgStream.send((byte[])this.paramValues[index]);
            return;
        }
        if (this.paramValues[index] instanceof StreamWrapper) {
            SimpleParameterList.streamBytea(pgStream, (StreamWrapper)this.paramValues[index]);
            return;
        }
        if (this.encoded[index] == null) {
            this.encoded[index] = Utils.encodeUTF8((String)this.paramValues[index]);
        }
        pgStream.send(this.encoded[index]);
    }

    @Override
    public ParameterList copy() {
        SimpleParameterList newCopy = new SimpleParameterList(this.paramValues.length, this.transferModeRegistry);
        System.arraycopy(this.paramLiteralValues, 0, newCopy.paramLiteralValues, 0, this.paramLiteralValues.length);
        System.arraycopy(this.paramValues, 0, newCopy.paramValues, 0, this.paramValues.length);
        System.arraycopy(this.paramTypes, 0, newCopy.paramTypes, 0, this.paramTypes.length);
        System.arraycopy(this.flags, 0, newCopy.flags, 0, this.flags.length);
        newCopy.pos = this.pos;
        return newCopy;
    }

    @Override
    public void clear() {
        Arrays.fill(this.paramValues, null);
        Arrays.fill(this.paramTypes, 0);
        Arrays.fill((Object[])this.encoded, null);
        Arrays.fill(this.flags, (byte)0);
        this.pos = 0;
    }

    @Override
    public SimpleParameterList[] getSubparams() {
        return null;
    }

    @Override
    public Object[] getValues() {
        return this.paramValues;
    }

    @Override
    public int[] getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public byte[] getFlags() {
        return this.flags;
    }

    @Override
    public byte[][] getEncoding() {
        return this.encoded;
    }

    @Override
    public void appendAll(ParameterList list) throws SQLException {
        if (list instanceof SimpleParameterList) {
            SimpleParameterList spl = (SimpleParameterList)list;
            int inParamCount = spl.getInParameterCount();
            if (this.pos + inParamCount > this.paramValues.length) {
                throw new PSQLException(GT.tr("Added parameters index out of range: {0}, number of columns: {1}.", this.pos + inParamCount, this.paramValues.length), PSQLState.INVALID_PARAMETER_VALUE);
            }
            System.arraycopy(spl.getValues(), 0, this.paramValues, this.pos, inParamCount);
            System.arraycopy(spl.getParamTypes(), 0, this.paramTypes, this.pos, inParamCount);
            System.arraycopy(spl.getFlags(), 0, this.flags, this.pos, inParamCount);
            System.arraycopy(spl.getEncoding(), 0, this.encoded, this.pos, inParamCount);
            this.pos += inParamCount;
        }
    }

    public String toString() {
        StringBuilder ts = new StringBuilder("<[");
        if (this.paramValues.length > 0) {
            ts.append(this.toString(1, true));
            for (int c = 2; c <= this.paramValues.length; ++c) {
                ts.append(" ,").append(this.toString(c, true));
            }
        }
        ts.append("]>");
        return ts.toString();
    }
}

