/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc;

import com.huawei.gaussdb.jdbc.Driver;
import com.huawei.gaussdb.jdbc.PGProperty;
import com.huawei.gaussdb.jdbc.clusterchooser.ClusterStatus;
import com.huawei.gaussdb.jdbc.core.QueryExecutor;
import com.huawei.gaussdb.jdbc.core.SetupQueryRunner;
import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import com.huawei.gaussdb.jdbc.util.HostSpec;
import com.huawei.gaussdb.jdbc.util.MapUtils;
import com.huawei.gaussdb.jdbc.util.PSQLException;
import com.huawei.gaussdb.jdbc.util.PSQLState;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class QueryCNListUtils {
    private static Map<String, CNList> clusterCNList = new HashMap<String, CNList>();
    private static Map<String, Boolean> firstConnectMap = new ConcurrentHashMap<String, Boolean>();
    private static Map<String, CNList> clusterDNList = new HashMap<String, CNList>();
    private static Map<String, String> targetDNList = new ConcurrentHashMap<String, String>();
    private static Log LOGGER = Logger.getLogger(QueryCNListUtils.class.getName());

    private static void setLOGGER() {
        if (!Logger.isUsingJDKLogger()) {
            LOGGER = Logger.getLogger(QueryCNListUtils.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HostSpec[] getCNList(String key, Properties properties, boolean block) {
        int intervalWaitHasRefreshedCNList = 10;
        int timesWaitHasRefreshedCNList = 200;
        for (int i = 0; i <= timesWaitHasRefreshedCNList; ++i) {
            Map<String, CNList> map = clusterCNList;
            synchronized (map) {
                CNList coordinationNodeList = clusterCNList.get(key);
                if (coordinationNodeList != null && coordinationNodeList.list != null) {
                    return coordinationNodeList.list;
                }
            }
            if (!block) break;
            try {
                Thread.sleep(intervalWaitHasRefreshedCNList);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.info("InterruptedException. This caused by: \"Thread.sleep\", waiting for refreshing CN List from connection.");
            }
        }
        if (block) {
            LOGGER.info("Blocking time exceeds 2 seconds need to pay attention.");
        }
        return Driver.GetHostSpecs(properties);
    }

    public static String keyFromURL(Properties props) {
        Object[] hostSpecs = Driver.getURLHostSpecs(props);
        String key = Arrays.toString(hostSpecs);
        if (QueryCNListUtils.isSingleNode(props)) {
            String execTargetNode = PGProperty.EXEC_TARGET_NODE.get(props);
            key = key + execTargetNode;
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshProperties(Properties props) {
        boolean block;
        QueryCNListUtils.setLOGGER();
        String key = QueryCNListUtils.keyFromURL(props);
        Map<String, Boolean> map = firstConnectMap;
        synchronized (map) {
            block = MapUtils.getOrDefault(firstConnectMap, key, false);
            firstConnectMap.put(key, true);
        }
        Object[] coordinatorNodeList = QueryCNListUtils.getCNList(key, props, block);
        if (coordinatorNodeList.length == 0) {
            return;
        }
        LOGGER.info("[AUTOBALANCE] The cluster obtains CNList from the user thread. | Cluster: " + key + " | CNList: " + Arrays.toString(coordinatorNodeList));
        StringBuilder hosts = new StringBuilder();
        StringBuilder ports = new StringBuilder();
        for (Object coordinatorNode : coordinatorNodeList) {
            hosts.append(((HostSpec)coordinatorNode).getHost() + ',');
            ports.append(String.valueOf(((HostSpec)coordinatorNode).getPort()) + ',');
        }
        props.setProperty("PGHOST", hosts.substring(0, hosts.length() - 1));
        props.setProperty("PGPORT", ports.substring(0, ports.length() - 1));
    }

    private static long getTimeToRefrshCNList(Properties props) {
        String refreshCNIpListTime = props.getProperty("refreshCNIpListTime", "10");
        Pattern pattern = Pattern.compile("[0-9]+");
        if (refreshCNIpListTime != null && pattern.matcher(refreshCNIpListTime).matches() && !refreshCNIpListTime.startsWith("0") && refreshCNIpListTime.length() < 5) {
            return (long)Integer.parseInt(refreshCNIpListTime) * 1000L;
        }
        return 10000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runRereshCNListQueryies(QueryExecutor queryExecutor, Properties info, ClusterStatus clusterStatus) throws SQLException, IOException {
        long checkLatestUpdate;
        CNList cnList;
        String cluster = QueryCNListUtils.keyFromURL(info);
        long latestAllowedUpdate = System.currentTimeMillis() - QueryCNListUtils.getTimeToRefrshCNList(info);
        Map<String, CNList> map = clusterCNList;
        synchronized (map) {
            cnList = clusterCNList.get(cluster);
            if (cnList == null) {
                cnList = new CNList(null);
                clusterCNList.put(cluster, cnList);
            }
            if (cnList.lastUpdated > latestAllowedUpdate) {
                return;
            }
            checkLatestUpdate = cnList.lastUpdated = System.currentTimeMillis();
        }
        ArrayList<HostSpec> cnListRefreshed = new ArrayList<HostSpec>();
        if (ClusterStatus.SecondaryCluster == clusterStatus) {
            String hosts = info.getProperty("PGHOST");
            String ports = info.getProperty("PGPORT");
            String[] hostList = hosts.split(",");
            for (int i = 0; i < hostList.length; ++i) {
                cnListRefreshed.add(new HostSpec(hostList[i], Integer.parseInt(ports.split(",")[i])));
            }
        } else {
            List<byte[][]> results;
            Boolean usingEip = PGProperty.USING_EIP.getBoolean(info);
            String query = usingEip != false ? "select node_host1,node_port1 from pgxc_node where node_type='C' and nodeis_active = true order by node_host1;" : "select node_host,node_port from pgxc_node where node_type='C' and nodeis_active = true order by node_host;";
            if (QueryCNListUtils.isSingleNode(info) && QueryCNListUtils.isSupportSessionType(queryExecutor)) {
                QueryCNListUtils.setSessionType(queryExecutor, "normal");
                results = SetupQueryRunner.runForList(queryExecutor, query, true);
                QueryCNListUtils.setSessionType(queryExecutor, "singleNode");
            } else {
                results = SetupQueryRunner.runForList(queryExecutor, query, true);
            }
            for (byte[][] result : results) {
                String host = queryExecutor.getEncoding().decode(result[0]);
                String port = queryExecutor.getEncoding().decode(result[1]);
                cnListRefreshed.add(new HostSpec(host, Integer.parseInt(port)));
            }
        }
        LOGGER.info("[AUTOBALANCE] Try to refreshing CN list, the cluster: " + cnListRefreshed + " connect To: " + queryExecutor.getHostSpec());
        Map<String, CNList> map2 = clusterCNList;
        synchronized (map2) {
            if (cnList.lastUpdated > checkLatestUpdate) {
                return;
            }
            cnList.list = cnListRefreshed.toArray(new HostSpec[0]);
            LOGGER.info("[AUTOBALANCE] For refreshing CN list, the cluster: " + Arrays.toString(cnList.list) + " connect To: " + queryExecutor.getHostSpec());
            cnList.lastUpdated = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runRefreshDNListQueryies(QueryExecutor queryExecutor, Properties info) throws SQLException, IOException {
        CNList dnList;
        if (!QueryCNListUtils.isSingleNode(info) || !QueryCNListUtils.isSupportSessionType(queryExecutor)) {
            return;
        }
        String cluster = QueryCNListUtils.keyFromURL(info);
        Map<String, CNList> map = clusterDNList;
        synchronized (map) {
            dnList = clusterDNList.get(cluster);
            if (dnList == null) {
                dnList = new CNList(null);
                clusterDNList.put(cluster, dnList);
            }
            dnList.lastUpdated = System.currentTimeMillis();
        }
        QueryCNListUtils.updateDNListQueryies(queryExecutor, info, dnList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateDNListQueryies(QueryExecutor queryExecutor, Properties info, CNList dnList) throws SQLException, IOException {
        boolean isEip = PGProperty.USING_EIP.getBoolean(info);
        String query = isEip ? "select node_host1,node_port1,node_name from pgxc_node where node_type='D' and nodeis_active = true order by node_host1;" : "select node_host,node_port,node_name from pgxc_node where node_type='D' and nodeis_active = true order by node_host;";
        QueryCNListUtils.setSessionType(queryExecutor, "normal");
        List<byte[][]> results = SetupQueryRunner.runForList(queryExecutor, query, true);
        QueryCNListUtils.setSessionType(queryExecutor, "singleNode");
        ArrayList<HostSpec> dnListRefreshed = new ArrayList<HostSpec>();
        String execTargetNode = PGProperty.EXEC_TARGET_NODE.get(info);
        String dnListRefreshedHost = null;
        for (byte[][] result : results) {
            if (result.length < 3) {
                LOGGER.error("query DNList failed");
                break;
            }
            String host = queryExecutor.getEncoding().decode(result[0]);
            String port = queryExecutor.getEncoding().decode(result[1]);
            String name = queryExecutor.getEncoding().decode(result[2]);
            if (dnListRefreshedHost == null && name.equals(execTargetNode)) {
                dnListRefreshedHost = host;
            }
            dnListRefreshed.add(new HostSpec(host, Integer.parseInt(port)));
        }
        if (dnListRefreshedHost == null) {
            throw new PSQLException("No dnNode found in GaussDB matches " + execTargetNode, PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[AUTOBALANCE] Try to refreshing DN list, the cluster: " + dnListRefreshed + " connect To: " + queryExecutor.getHostSpec());
        }
        Map<String, CNList> map = targetDNList;
        synchronized (map) {
            targetDNList.put(QueryCNListUtils.keyFromURL(info), dnListRefreshedHost);
        }
        map = clusterDNList;
        synchronized (map) {
            dnList.list = dnListRefreshed.toArray(new HostSpec[0]);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("[AUTOBALANCE] For refreshing DN list, the cluster: " + Arrays.toString(dnList.list) + " connect To: " + queryExecutor.getHostSpec());
            }
            dnList.lastUpdated = System.currentTimeMillis();
        }
    }

    private static void setSessionType(QueryExecutor queryExecutor, String singleNode) throws SQLException {
        if (singleNode != null && singleNode.contains("normal")) {
            String query = "set session_type='normal'";
            SetupQueryRunner.runForList(queryExecutor, query, false);
        } else if (singleNode != null && singleNode.contains("singleNode")) {
            String query = "set session_type='single_node'";
            SetupQueryRunner.runForList(queryExecutor, query, false);
        } else {
            return;
        }
    }

    public static String getTargetHost(Properties info) {
        String cluster = QueryCNListUtils.keyFromURL(info);
        String targetHost = targetDNList.get(cluster);
        if (targetHost == null) {
            return "";
        }
        return targetHost;
    }

    public static boolean isSingleNode(Properties props) {
        String execTargetNode;
        String sessionType = PGProperty.SESSION_TYPE.get(props);
        return "singleNode".equalsIgnoreCase(sessionType) && (execTargetNode = PGProperty.EXEC_TARGET_NODE.get(props)) != null && !"".equals(execTargetNode);
    }

    public static boolean isSupportSessionType(QueryExecutor queryExecutor) throws SQLException, IOException {
        String query = "select count(1) from pg_settings where name = 'session_type';";
        List<byte[][]> results = SetupQueryRunner.runForList(queryExecutor, query, true);
        if (results == null || results.isEmpty()) {
            return false;
        }
        String count = queryExecutor.getEncoding().decode(results.get(0)[0]);
        return Integer.parseInt(count) == 1;
    }

    static class CNList {
        HostSpec[] list;
        long lastUpdated;

        CNList(HostSpec[] cnList) {
            this.list = cnList;
        }
    }
}

