/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.dubbo.collector.sampling;

import com.lubanops.apm.bootstrap.api.APIService;
import com.lubanops.apm.bootstrap.config.ConfigManager;
import com.lubanops.apm.bootstrap.config.Stats;
import com.lubanops.apm.plugin.dubbo.collector.sampling.MethodConfig;
import com.lubanops.apm.plugin.dubbo.collector.sampling.MethodPattern;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DubboSampleStatsConfig {
    private static final int SLOW_REQUEST_THRESHOLD_DEFAULT = ConfigManager.getSlowRequestThreshold();
    public Stats slowRequestTraceCountStats = ConfigManager.getSlowRequestTraceCountStats();
    public Stats errorRequestTraceCounStats = ConfigManager.getErrorRequestTraceCounStats();
    public Stats requestTraceCountStats = ConfigManager.getRequestTranceCountStats();
    public MethodConfig defaultSampleConfig = new MethodConfig();
    private int slowRequestThreshold = SLOW_REQUEST_THRESHOLD_DEFAULT;
    private List<MethodPattern> excludeMethodList = new ArrayList<MethodPattern>();
    private Map<MethodPattern, MethodConfig> methodMap = new HashMap<MethodPattern, MethodConfig>();

    public MethodConfig getSampleConfig(String group, String service, String version, String method) {
        MethodConfig methodConfig = this.getMethodConfig(group, service, version, method);
        return methodConfig;
    }

    public boolean isExclude(String group, String service, String version, String method) {
        boolean exclude = Boolean.FALSE;
        for (MethodPattern pattern : this.excludeMethodList) {
            if (!pattern.matches(group, service, version, method)) continue;
            exclude = Boolean.TRUE;
            break;
        }
        return exclude;
    }

    public int getSlowRequestThreshold(String group, String service, String version, String method) {
        MethodConfig methodConfig = this.getMethodConfig(group, service, version, method);
        if (methodConfig != null && methodConfig.getSlowRequestThreshold() != null) {
            return methodConfig.getSlowRequestThreshold();
        }
        return this.slowRequestThreshold;
    }

    private MethodConfig getMethodConfig(String group, String service, String version, String method) {
        MethodConfig methodConfig = this.defaultSampleConfig;
        Set<Map.Entry<MethodPattern, MethodConfig>> set = this.methodMap.entrySet();
        for (Map.Entry<MethodPattern, MethodConfig> entry : set) {
            if (!entry.getKey().matches(group, service, version, method)) continue;
            methodConfig = entry.getValue();
            break;
        }
        return methodConfig;
    }

    public void setSlowRequestThreshold(Integer slowRequestThreshold) {
        this.slowRequestThreshold = slowRequestThreshold != null ? slowRequestThreshold : SLOW_REQUEST_THRESHOLD_DEFAULT;
    }

    public void setSlowRequestTraceCountStats(Stats slowRequestTraceCountStats) {
        if (slowRequestTraceCountStats != null) {
            this.slowRequestTraceCountStats = slowRequestTraceCountStats;
        }
    }

    public void setErrorRequestTraceCounStats(Stats errorRequestTraceCounStats) {
        if (errorRequestTraceCounStats != null) {
            this.errorRequestTraceCounStats = errorRequestTraceCounStats;
        }
    }

    public void setRequestTraceCountStats(Stats requestTraceCountStats) {
        if (requestTraceCountStats != null) {
            this.requestTraceCountStats = requestTraceCountStats;
        }
    }

    public void setIncludeList(Map includeMap) {
        if (includeMap == null || includeMap.isEmpty()) {
            return;
        }
        HashMap<MethodPattern, MethodConfig> newMethodConfigs = new HashMap<MethodPattern, MethodConfig>();
        Set set = includeMap.entrySet();
        for (Map.Entry entry : set) {
            Object patternStr = entry.getKey();
            newMethodConfigs.put(((MethodPattern)APIService.getJsonApi().parseObject(patternStr.toString(), MethodPattern.class)).build(), (MethodConfig)((Object)APIService.getJsonApi().parseObject(entry.getValue().toString(), MethodConfig.class)));
        }
        this.methodMap = newMethodConfigs;
    }

    public void setExcludeList(List<MethodPattern> excludeList) {
        if (excludeList == null || excludeList.isEmpty()) {
            return;
        }
        this.excludeMethodList = excludeList;
        for (MethodPattern pattern : this.excludeMethodList) {
            pattern.build();
        }
    }

    public MethodConfig getDefaultSampleConfig() {
        return this.defaultSampleConfig;
    }

    public void setDefaultSampleConfig(MethodConfig defaultSampleConfig) {
        this.defaultSampleConfig = defaultSampleConfig;
    }
}

