/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.oracle.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.plugin.oracle.OracleTrace;
import com.lubanops.apm.plugin.oracle.OracleUtils;
import com.lubanops.apm.plugin.oracle.collector.OracleCollector;
import oracle.jdbc.OracleStatement;
import oracle.jdbc.driver.OracleSql;

public class PreparedStatementExecuteInterceptor
implements Interceptor {
    public Object[] onStart(Object statementObject, Object[] args, String className, String methodName) {
        try {
            if (OracleCollector.INSTANCE.isEnable()) {
                String sql;
                Object[] attributes = ((AttributeAccess)statementObject).getLopsFileds();
                OracleSql sqlObject = (OracleSql)attributes[0];
                Object autoKeyInfo = attributes[1];
                String originSql = sql = (String)((AttributeAccess)sqlObject).getLopsFileds()[0];
                if (autoKeyInfo != null) {
                    originSql = (String)((AttributeAccess)autoKeyInfo).getLopsFileds()[0];
                }
                Integer id = OracleUtils.getConnectionId((OracleStatement)statementObject);
                OracleUtils.onStatementStart(originSql, id);
                OracleTrace.onStart(className, methodName, sql, originSql, id);
            }
        }
        catch (Exception stmtExecuteException) {
            LogFactory.getLogger().log(Level.SEVERE, "StatementExecuteInterceptor onStart error", (Throwable)stmtExecuteException);
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (OracleCollector.INSTANCE.isEnable()) {
                OracleSql sqlObject = (OracleSql)((AttributeAccess)object).getLopsFileds()[0];
                Object[] attributes = ((AttributeAccess)sqlObject).getLopsFileds();
                String sql = (String)attributes[0];
                OracleUtils.onStatementError(sql, e);
                OracleTrace.onError(e);
            }
        }
        catch (Exception stmtExecuteException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)stmtExecuteException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (OracleCollector.INSTANCE.isEnable()) {
                OracleStatement statement = (OracleStatement)object;
                OracleSql sqlObject = (OracleSql)((AttributeAccess)object).getLopsFileds()[0];
                Object[] attributes = ((AttributeAccess)sqlObject).getLopsFileds();
                String sql = (String)attributes[0];
                OracleUtils.SqlKind sqlKind = OracleUtils.getSqlKind(sql);
                int updatedRowCount = 0;
                int readRowCount = 0;
                int validRows = OracleUtils.getRowCount(statement);
                if (sqlKind.equals((Object)OracleUtils.SqlKind.READ)) {
                    readRowCount = validRows;
                } else if (sqlKind.equals((Object)OracleUtils.SqlKind.UPSERT)) {
                    updatedRowCount = validRows;
                }
                OracleUtils.onStatementFinally(sql, updatedRowCount, readRowCount);
                OracleTrace.onFinally(updatedRowCount, readRowCount);
            }
        }
        catch (Exception stmtExecuteException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)stmtExecuteException);
        }
    }
}

