/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.clickhouse.interceptor;

import com.clickhouse.jdbc.parser.ClickHouseSqlStatement;
import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.ExcludePluginLocal;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.clickhouse.ClickHouseTrace;
import com.lubanops.apm.plugin.clickhouse.ClickHouseUtils;
import com.lubanops.apm.plugin.clickhouse.collector.ClickHouseCollector;
import java.security.ProtectionDomain;
import ru.yandex.clickhouse.ClickHouseConnectionImpl;
import ru.yandex.clickhouse.ClickHousePreparedStatementImpl;
import ru.yandex.clickhouse.ClickHouseStatementImpl;
import ru.yandex.clickhouse.Writer;
import ru.yandex.clickhouse.response.ClickHouseResponseSummary;

public class SendInputInterceptor
implements Interceptor {
    public SendInputInterceptor() {
        ClickHouseCollector.setDriverVersion(Util.getJarVersionFromProtectionDomain((ProtectionDomain)ClickHouseConnectionImpl.class.getProtectionDomain()));
    }

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (ClickHouseCollector.INSTANCE.isEnable()) {
                ClickHouseSqlStatement parsedStmt;
                String originSql;
                ClickHouseStatementImpl statement = (ClickHouseStatementImpl)object;
                String parsedSql = originSql = this.getSql(args);
                if (object instanceof ClickHousePreparedStatementImpl && object instanceof AttributeAccess && StringUtils.isBlank((String)(parsedSql = (String)((AttributeAccess)object).getLopsFileds()[0])) && (parsedStmt = (ClickHouseSqlStatement)((AttributeAccess)object).getLopsFileds()[1]) != null) {
                    parsedSql = parsedStmt.getSQL();
                }
                Integer id = ClickHouseUtils.getConnectionId(statement);
                String clusterUrls = ClickHouseUtils.getClusterUrlsElseNull(statement);
                ClickHouseUtils.onStatementStart(parsedSql, id, clusterUrls);
                ClickHouseTrace.onStart(className, methodName, parsedSql, originSql, id);
                ExcludePluginLocal.EXCLUDE_PLUGIN_FLAG.set(Boolean.TRUE);
            }
        }
        catch (Exception stmtExecuteException) {
            LogFactory.getLogger().log(Level.SEVERE, "StatementExecuteInterceptor onStart error", (Throwable)stmtExecuteException);
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (ClickHouseCollector.INSTANCE.isEnable()) {
                String sql = this.getSql(args);
                ClickHouseUtils.onStatementError(sql, e);
                ClickHouseTrace.onError(e);
            }
        }
        catch (Exception stmtExecuteException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)stmtExecuteException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        block5: {
            try {
                if (!ClickHouseCollector.INSTANCE.isEnable()) break block5;
                ClickHouseStatementImpl statement = (ClickHouseStatementImpl)object;
                String sql = this.getSql(args);
                int readRowCount = 0;
                int updatedRowCount = 0;
                try {
                    ClickHouseResponseSummary currentSummary = statement.getResponseSummary();
                    if (currentSummary != null) {
                        readRowCount = (int)currentSummary.getReadRows();
                        updatedRowCount = (int)currentSummary.getWrittenRows();
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                ClickHouseCollector.onConnectionEnd(sql, updatedRowCount, readRowCount);
                ClickHouseCollector.onFinally(updatedRowCount, readRowCount);
                ClickHouseTrace.onFinally(updatedRowCount, readRowCount);
                ExcludePluginLocal.EXCLUDE_PLUGIN_FLAG.remove();
            }
            catch (Exception stmtExecuteException) {
                LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)stmtExecuteException);
            }
        }
    }

    private String getSql(Object[] args) {
        if (args[0] instanceof String) {
            return (String)args[0];
        }
        if (args[0] instanceof Writer) {
            return ClickHouseUtils.getWriterSql((Writer)args[0]);
        }
        if (args[0] instanceof ClickHouseSqlStatement) {
            ClickHouseSqlStatement parsedStmt = (ClickHouseSqlStatement)args[0];
            return parsedStmt.getSQL();
        }
        return "unknown";
    }
}

